/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;

class CountermandEffect
extends OneShotEffect {
    CountermandEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell. Its controller mills four cards.";
    }

    private CountermandEffect(CountermandEffect effect) {
        super((OneShotEffect)effect);
    }

    public CountermandEffect copy() {
        return new CountermandEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller;
        boolean countered = false;
        StackObject stackObject = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (game.getStack().counter(source.getFirstTarget(), source, game)) {
            countered = true;
        }
        if (stackObject != null && (controller = game.getPlayer(stackObject.getControllerId())) != null) {
            controller.millCards(4, source, game);
        }
        return countered;
    }
}

