/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.c.CourtOfLocthwain;
import mage.cards.c.CourtOfLocthwainWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CourtOfLocthwainCastForFreeEffect
extends AsThoughEffectImpl {
    private final MageObjectReference mor;

    public CourtOfLocthwainCastForFreeEffect(MageObjectReference mor) {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.EndOfTurn, Outcome.Benefit);
        this.mor = mor;
    }

    private CourtOfLocthwainCastForFreeEffect(CourtOfLocthwainCastForFreeEffect effect) {
        super((AsThoughEffectImpl)effect);
        this.mor = effect.mor;
    }

    public CourtOfLocthwainCastForFreeEffect copy() {
        return new CourtOfLocthwainCastForFreeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        if (!affectedControllerId.equals(source.getControllerId())) {
            return false;
        }
        Player controller = game.getPlayer(source.getControllerId());
        CourtOfLocthwainWatcher watcher = (CourtOfLocthwainWatcher)game.getState().getWatcher(CourtOfLocthwainWatcher.class);
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller == null || watcher == null || sourceObject == null) {
            return false;
        }
        UUID exileId = CourtOfLocthwain.getExileZoneId(this.mor, game);
        ExileZone exileZone = game.getExile().getExileZone(exileId);
        Card card = game.getCard(objectId);
        if (exileZone == null || card == null || !exileZone.contains((Object)card.getMainCard().getId())) {
            return false;
        }
        if (1 > watcher.castStillAvailable(controller.getId(), new MageObjectReference((MageObject)sourceObject, game))) {
            return false;
        }
        this.allowCardToPlayWithoutMana(objectId, source, affectedControllerId, MageIdentifier.CourtOfLocthwainWatcher, game);
        return true;
    }
}

