/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageIdentifier;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.AbilityImpl;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.c.CourtOfLocthwainCastForFreeEffect;
import mage.cards.c.CourtOfLocthwainWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CourtOfLocthwainSecondEffect
extends OneShotEffect {
    CourtOfLocthwainSecondEffect() {
        super(Outcome.Benefit);
        this.staticText = "until end of turn, you may cast a spell from among cards exiled with {this} without paying its mana cost";
    }

    private CourtOfLocthwainSecondEffect(CourtOfLocthwainSecondEffect effect) {
        super((OneShotEffect)effect);
    }

    public CourtOfLocthwainSecondEffect copy() {
        return new CourtOfLocthwainSecondEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        CourtOfLocthwainWatcher watcher = (CourtOfLocthwainWatcher)game.getState().getWatcher(CourtOfLocthwainWatcher.class);
        Permanent sourceObject = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller == null || watcher == null || sourceObject == null) {
            return false;
        }
        MageObjectReference mor = new MageObjectReference((MageObject)sourceObject, game);
        AbilityImpl sourceWithIdentifier = source.copy().setIdentifier(MageIdentifier.CourtOfLocthwainWatcher);
        game.addEffect((ContinuousEffect)new CourtOfLocthwainCastForFreeEffect(mor), (Ability)sourceWithIdentifier);
        watcher.setOrIncrementCastAvailable(controller.getId(), mor);
        return true;
    }
}

