/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class CovetousElegyEffect
extends OneShotEffect {
    CovetousElegyEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player chooses up to two creatures they control, then sacrifices the rest";
    }

    private CovetousElegyEffect(CovetousElegyEffect effect) {
        super((OneShotEffect)effect);
    }

    public CovetousElegyEffect copy() {
        return new CovetousElegyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        HashSet creatures = new HashSet();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent(0, 2);
            target.withNotTarget(true);
            target.withChooseHint("the rest will be sacrificed");
            player.choose(this.outcome, (Target)target, source, game);
            creatures.addAll(target.getTargets());
        }
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (creatures.contains(permanent.getId())) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

