/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class CrabominationEffect
extends OneShotEffect {
    CrabominationEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent exiles the top card of their library, a card at random from their graveyard, and a card at random from their hand. You may cast a spell from among cards exiled this way without paying its mana cost";
    }

    private CrabominationEffect(CrabominationEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrabominationEffect copy() {
        return new CrabominationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card fromHand;
        Card fromGraveyard;
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (opponent == null || controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        Card fromTop = opponent.getLibrary().getFromTop(game);
        if (fromTop != null) {
            cards.add(fromTop);
        }
        if ((fromGraveyard = opponent.getGraveyard().getRandom(game)) != null) {
            cards.add(fromGraveyard);
        }
        if ((fromHand = opponent.getHand().getRandom(game)) != null) {
            cards.add(fromHand);
        }
        opponent.moveCardsToExile(cards.getCards(game), source, game, true, null, "");
        game.processAction();
        cards.retainZone(Zone.EXILED, game);
        CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD);
        return true;
    }
}

