/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.GreatestPowerControlledPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class CracklingDoomEffect
extends OneShotEffect {
    static FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("creature with the greatest power among creatures you control");

    public CracklingDoomEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Each opponent sacrifices a creature with the greatest power among creatures that player controls";
    }

    private CracklingDoomEffect(CracklingDoomEffect effect) {
        super((OneShotEffect)effect);
    }

    public CracklingDoomEffect copy() {
        return new CracklingDoomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ArrayList<Permanent> toSacrifice = new ArrayList<Permanent>();
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Permanent permanent;
                Player opponent;
                if (!controller.hasOpponent(playerId, game) || (opponent = game.getPlayer(playerId)) == null) continue;
                TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                target.withNotTarget(true);
                if (!opponent.choose(this.outcome, (Target)target, source, game) || (permanent = game.getPermanent(target.getFirstTarget())) == null) continue;
                toSacrifice.add(permanent);
            }
            for (Permanent permanent : toSacrifice) {
                permanent.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)GreatestPowerControlledPredicate.instance);
    }
}

