/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CranialArchiveEffect
extends OneShotEffect {
    CranialArchiveEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target player shuffles their graveyard into their library. Draw a card";
    }

    private CranialArchiveEffect(CranialArchiveEffect effect) {
        super((OneShotEffect)effect);
    }

    public CranialArchiveEffect copy() {
        return new CranialArchiveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (targetPlayer != null) {
                for (Card card : targetPlayer.getGraveyard().getCards(game)) {
                    targetPlayer.moveCardToLibraryWithInfo(card, source, game, Zone.GRAVEYARD, true, true);
                }
                targetPlayer.shuffleLibrary(source, game);
            }
            controller.drawCards(1, source, game);
            return true;
        }
        return false;
    }
}

