/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CreepingBloodsuckerEffect
extends OneShotEffect {
    public CreepingBloodsuckerEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 1 damage to each opponent. You gain life equal to the damage dealt this way";
    }

    private CreepingBloodsuckerEffect(CreepingBloodsuckerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int damageDealt = 0;
        Player player = game.getPlayer(source.getControllerId());
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            if (!player.hasOpponent(playerId, game)) continue;
            damageDealt += game.getPlayer(playerId).damage(1, source.getSourceId(), source, game);
        }
        if (damageDealt > 0) {
            game.getPlayer(source.getControllerId()).gainLife(damageDealt, game, source);
        }
        return true;
    }

    public CreepingBloodsuckerEffect copy() {
        return new CreepingBloodsuckerEffect(this);
    }
}

