/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class CreepingDreadEffect
extends OneShotEffect {
    CreepingDreadEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player discards a card. Each opponent who discarded a card that shares a card type with the card you discarded loses 3 life.";
    }

    private CreepingDreadEffect(CreepingDreadEffect effect) {
        super((OneShotEffect)effect);
    }

    public CreepingDreadEffect copy() {
        return new CreepingDreadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashSet typesChosen = new HashSet();
            HashMap<Player, Card> cardsChosen = new HashMap<Player, Card>();
            if (!controller.getHand().isEmpty()) {
                Card card;
                TargetCard controllerTarget = new TargetCard(Zone.HAND, new FilterCard());
                if (controller.choose(Outcome.Discard, controller.getHand(), controllerTarget, source, game) && (card = controller.getHand().get(controllerTarget.getFirstTarget(), game)) != null) {
                    typesChosen = new HashSet(card.getCardType(game));
                    cardsChosen.put(controller, card);
                }
            }
            HashSet<Player> opponentsAffected = new HashSet<Player>();
            for (UUID uUID : game.getOpponents(source.getControllerId())) {
                Card card;
                Player opponent = game.getPlayer(uUID);
                if (opponent == null || opponent.getHand().isEmpty()) continue;
                TargetCard target = new TargetCard(Zone.HAND, new FilterCard());
                if (!opponent.choose(Outcome.Discard, opponent.getHand(), target, source, game) || (card = opponent.getHand().get(target.getFirstTarget(), game)) == null) continue;
                if (!typesChosen.isEmpty()) {
                    block1: for (CardType cType : typesChosen) {
                        for (CardType oType : card.getCardType(game)) {
                            if (cType != oType) continue;
                            opponentsAffected.add(opponent);
                            continue block1;
                        }
                    }
                }
                cardsChosen.put(opponent, card);
            }
            if (!cardsChosen.isEmpty()) {
                for (Map.Entry entry : cardsChosen.entrySet()) {
                    Player player = (Player)entry.getKey();
                    Card cardChosen = (Card)entry.getValue();
                    if (player == null) continue;
                    player.discard(cardChosen, false, source, game);
                }
            }
            if (!opponentsAffected.isEmpty()) {
                for (Player player : opponentsAffected) {
                    player.loseLife(3, game, source, false);
                }
            }
            return true;
        }
        return false;
    }
}

