/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.util.CardUtil;

class CreepingInnEffect
extends OneShotEffect {
    CreepingInnEffect() {
        super(Outcome.Exile);
        this.staticText = "you may exile a creature card from your graveyard. If you do, each opponent loses X life and you gain X life, where X is the number of creature cards exiled with {this}.";
    }

    private CreepingInnEffect(CreepingInnEffect effect) {
        super((OneShotEffect)effect);
    }

    public CreepingInnEffect copy() {
        return new CreepingInnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (player != null && permanent != null) {
            Card cardChosen;
            UUID exileId = CardUtil.getExileZoneId((Game)game, (Ability)source);
            TargetCardInGraveyard target = new TargetCardInGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
            target.withNotTarget(true);
            if (target.canChoose(player.getId(), source, game) && player.choose(Outcome.Exile, (Target)target, source, game) && (cardChosen = game.getCard(target.getFirstTarget())) != null) {
                int lifeAmount = 0;
                player.moveCardsToExile(cardChosen, source, game, true, exileId, permanent.getName());
                ExileZone exile = game.getExile().getExileZone(exileId);
                if (exile != null) {
                    for (UUID cardId : exile) {
                        ++lifeAmount;
                    }
                }
                for (UUID playerId : game.getOpponents(source.getControllerId())) {
                    game.getPlayer(playerId).loseLife(lifeAmount, game, source, false);
                }
                player.gainLife(lifeAmount, game, source);
            }
            return true;
        }
        return false;
    }
}

