/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.CommanderPredicate;
import mage.game.Game;
import mage.players.Player;

class CrimsonHonorGuardEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent("Commander");

    public CrimsonHonorGuardEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 4 damage to that player unless they control a commander";
    }

    private CrimsonHonorGuardEffect(CrimsonHonorGuardEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int numCommanders;
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player != null && (numCommanders = game.getBattlefield().getAllActivePermanents(filter, player.getId(), game).size()) == 0) {
            player.damage(4, source.getSourceId(), source, game);
            return true;
        }
        return false;
    }

    public CrimsonHonorGuardEffect copy() {
        return new CrimsonHonorGuardEffect(this);
    }

    static {
        filter.add((Predicate)CommanderPredicate.instance);
    }
}

