/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeControllerEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CrovaxTheCursedEffect
extends OneShotEffect {
    CrovaxTheCursedEffect() {
        super(Outcome.Detriment);
        this.staticText = "you may sacrifice a creature. If you do, put a +1/+1 counter on {this}. If you don't, remove a +1/+1 counter from {this}";
    }

    private CrovaxTheCursedEffect(CrovaxTheCursedEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrovaxTheCursedEffect copy() {
        return new CrovaxTheCursedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent sourceObject = source.getSourcePermanentIfItStillExists(game);
            int creatures = game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, source.getControllerId(), game);
            if (creatures > 0 && controller.chooseUse(this.outcome, "Sacrifice a creature?", source, game)) {
                if (new SacrificeControllerEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES, 1, "").apply(game, source) && sourceObject != null) {
                    sourceObject.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
                    game.informPlayers(controller.getLogName() + " puts a +1/+1 counter on " + sourceObject.getName());
                }
            } else if (sourceObject != null && sourceObject.getCounters(game).containsKey(CounterType.P1P1)) {
                sourceObject.removeCounters(CounterType.P1P1.getName(), 1, source, game);
                game.informPlayers(controller.getLogName() + " removes a +1/+1 counter from " + sourceObject.getName());
            }
            return true;
        }
        return false;
    }
}

