/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.DealsDamageToACreatureTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class CruelDeceiverEffect
extends OneShotEffect {
    CruelDeceiverEffect() {
        super(Outcome.AddAbility);
        this.staticText = "Reveal the top card of your library. If it's a land card, {this} gains \"Whenever {this} deals damage to a creature, destroy that creature\" until end of turn";
    }

    private CruelDeceiverEffect(CruelDeceiverEffect effect) {
        super((OneShotEffect)effect);
    }

    public CruelDeceiverEffect copy() {
        return new CruelDeceiverEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller != null && sourceObject != null) {
            CardsImpl cards = new CardsImpl();
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                cards.add(card);
                controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
                if (card.isLand(game)) {
                    game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)new DealsDamageToACreatureTriggeredAbility((Effect)new DestroyTargetEffect(true), false, false, true), Duration.EndOfTurn), source);
                }
            }
            return true;
        }
        return false;
    }
}

