/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.condition.common.GiftWasPromisedCondition;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class CruelclawsHeistEffect
extends OneShotEffect {
    CruelclawsHeistEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent reveals their hand. You choose a nonland card from it. Exile that card. If the gift was promised, you may cast that card for as long as it remains exiled, and mana of any type can be spent to cast it";
    }

    private CruelclawsHeistEffect(CruelclawsHeistEffect effect) {
        super((OneShotEffect)effect);
    }

    public CruelclawsHeistEffect copy() {
        return new CruelclawsHeistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null || opponent.getHand().isEmpty()) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)opponent.getHand());
        opponent.revealCards(source, (Cards)cards, game);
        if (cards.count((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game) < 1) {
            return true;
        }
        TargetCardInHand target = new TargetCardInHand((FilterCard)StaticFilters.FILTER_CARD_NON_LAND);
        controller.choose(Outcome.Discard, (Cards)cards, (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return true;
        }
        controller.moveCards(card, Zone.EXILED, source, game);
        if (GiftWasPromisedCondition.TRUE.apply(game, source)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.Custom, (boolean)true);
        }
        return true;
    }
}

