/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CryOfTheCarnariumReplacementEffect
extends ReplacementEffectImpl {
    CryOfTheCarnariumReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Exile);
        this.staticText = " If a creature would die this turn, exile it instead.";
    }

    private CryOfTheCarnariumReplacementEffect(CryOfTheCarnariumReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public CryOfTheCarnariumReplacementEffect copy() {
        return new CryOfTheCarnariumReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player;
        Permanent permanent = ((ZoneChangeEvent)event).getTarget();
        if (permanent != null && (player = game.getPlayer(permanent.getControllerId())) != null) {
            return player.moveCards((Card)permanent, Zone.EXILED, source, game);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getTarget() != null && zEvent.getTarget().isCreature(game) && zEvent.isDiesEvent();
    }
}

