/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class CryptChampionEffect
extends OneShotEffect {
    CryptChampionEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "each player puts a creature card with mana value 3 or less from their graveyard onto the battlefield";
    }

    private CryptChampionEffect(CryptChampionEffect effect) {
        super((OneShotEffect)effect);
    }

    public CryptChampionEffect copy() {
        return new CryptChampionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        HashSet<Card> toBattlefield = new HashSet<Card>();
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Card card;
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                FilterCreatureCard filter = new FilterCreatureCard("creature card with mana value 3 or less from your graveyard");
                filter.add((Predicate)new OwnerIdPredicate(playerId));
                filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 4));
                TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)filter);
                if (!target.canChoose(playerId, source, game) || !player.chooseTarget(this.outcome, (Target)target, source, game) || (card = game.getCard(target.getFirstTarget())) == null) continue;
                toBattlefield.add(card);
            }
            controller.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game, false, false, true, null);
            return true;
        }
        return false;
    }
}

