/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CrypticPursuitExileAndPlayEffect
extends OneShotEffect {
    CrypticPursuitExileAndPlayEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile it if it's an instant or sorcery card. You may cast that card until the end of your next turn.";
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Object diedObject = this.getValue("creatureDied");
        if (controller == null || !(diedObject instanceof Permanent)) {
            return false;
        }
        Permanent diedFaceDownCreature = (Permanent)diedObject;
        Card card = game.getCard(diedFaceDownCreature.getMainCard().getId());
        if (card == null || !card.isInstantOrSorcery(game)) {
            return false;
        }
        PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile((Game)game, (Ability)source, (Card)card, (TargetController)TargetController.YOU, (Duration)Duration.UntilEndOfYourNextTurn, (boolean)false, (boolean)false, (boolean)true);
        return false;
    }

    private CrypticPursuitExileAndPlayEffect(CrypticPursuitExileAndPlayEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrypticPursuitExileAndPlayEffect copy() {
        return new CrypticPursuitExileAndPlayEffect(this);
    }
}

