/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.ManaUtil;

class CrystalShardEffect
extends OneShotEffect {
    CrystalShardEffect() {
        super(Outcome.Detriment);
        this.staticText = "return target creature to its owner's hand unless its controller pays {1}";
    }

    private CrystalShardEffect(CrystalShardEffect effect) {
        super((OneShotEffect)effect);
    }

    public CrystalShardEffect copy() {
        return new CrystalShardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller == null || targetCreature == null) {
            return true;
        }
        Player player = game.getPlayer(targetCreature.getControllerId());
        if (player == null) {
            return true;
        }
        ManaCost cost = ManaUtil.createManaCost((int)1, (boolean)false);
        String message = "Pay {1}? (Otherwise " + targetCreature.getName() + " will be returned to its owner's hand)";
        if (player.chooseUse(Outcome.Benefit, message, source, game)) {
            cost.pay(source, game, source, targetCreature.getControllerId(), false, null);
        }
        return cost.isPaid() || controller.moveCards((Card)targetCreature, Zone.HAND, source, game);
    }
}

