/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.ManaType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class CullingRitualEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterNonlandPermanent();

    CullingRitualEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy each nonland permanent with mana value 2 or less. Add {B} or {G} for each permanent destroyed this way";
    }

    private CullingRitualEffect(CullingRitualEffect effect) {
        super((OneShotEffect)effect);
    }

    public CullingRitualEffect copy() {
        return new CullingRitualEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int counter = 0;
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            counter += permanent.destroy(source, game, false) ? 1 : 0;
        }
        if (counter == 0) {
            return false;
        }
        int black = player.getAmount(0, counter, counter + " permanents were destroyed, choose the amount of black mana to produce (the rest will be green)", source, game);
        Mana mana = new Mana(ManaType.BLACK, black);
        if (black < counter) {
            mana.add(new Mana(ManaType.GREEN, counter - black));
        }
        player.getManaPool().addMana(mana, game, source);
        return true;
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 3));
    }
}

