/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.WolfToken;

class CultOfTheWaxingMoonAbility
extends TriggeredAbilityImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();

    public CultOfTheWaxingMoonAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new WolfToken()), false);
        this.setTriggerPhrase("Whenever a permanent you control transforms into a non-Human creature, ");
    }

    private CultOfTheWaxingMoonAbility(CultOfTheWaxingMoonAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CultOfTheWaxingMoonAbility copy() {
        return new CultOfTheWaxingMoonAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TRANSFORMED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return filter.match(permanent, this.getControllerId(), (Ability)this, game);
    }

    static {
        filter.add(Predicates.not((Predicate)SubType.HUMAN.getPredicate()));
    }
}

