/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CuriosityAbility
extends TriggeredAbilityImpl {
    public CuriosityAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DrawCardSourceControllerEffect(1), true);
    }

    private CuriosityAbility(CuriosityAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CuriosityAbility copy() {
        return new CuriosityAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        return permanent != null && game.getOpponents(this.controllerId).contains(event.getTargetId()) && permanent.getAttachments().contains(this.getSourceId());
    }

    public String getRule() {
        return "Whenever enchanted creature deals damage to an opponent, you may draw a card.";
    }
}

