/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.EmbalmAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;

class CurseClothWrappingsEffect
extends ContinuousEffectImpl {
    public CurseClothWrappingsEffect() {
        super(Duration.EndOfTurn, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "Target creature card in your graveyard gains embalm until end of turn. The embalm cost is equal to its mana cost. (Exile that card and pay its embalm cost: Create a token that's a copy of it, except it's a white Zombie in addition to its other types and has no mana cost. Embalm only as a sorcery.)";
    }

    public CurseClothWrappingsEffect(CurseClothWrappingsEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public CurseClothWrappingsEffect copy() {
        return new CurseClothWrappingsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card != null) {
            EmbalmAbility embalmAbility = new EmbalmAbility((Cost)card.getManaCost(), card);
            game.getState().addOtherAbility(card, (Ability)embalmAbility);
            return true;
        }
        return false;
    }
}

