/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class CurseOfBloodlettingEffect
extends ReplacementEffectImpl {
    CurseOfBloodlettingEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a source would deal damage to enchanted player, it deals double that damage to that player instead";
    }

    private CurseOfBloodlettingEffect(CurseOfBloodlettingEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public CurseOfBloodlettingEffect copy() {
        return new CurseOfBloodlettingEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        return enchantment != null && enchantment.isAttachedTo(event.getTargetId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

