/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class CurseOfEchoesEffect
extends OneShotEffect {
    CurseOfEchoesEffect() {
        super(Outcome.Copy);
        this.staticText = "each other player may copy that spell and may choose new targets for the copy they control";
    }

    private CurseOfEchoesEffect(CurseOfEchoesEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            String chooseMessage = "Copy target spell?  You may choose new targets for the copy.";
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player;
                if (spell.isControlledBy(playerId) || (player = game.getPlayer(playerId)) == null || !player.chooseUse(Outcome.Copy, chooseMessage, source, game)) continue;
                spell.createCopyOnStack(game, source, player.getId(), true);
            }
            return true;
        }
        return false;
    }

    public CurseOfEchoesEffect copy() {
        return new CurseOfEchoesEffect(this);
    }
}

