/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.c.CurseOfHospitalityEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CurseOfHospitalityTriggeredAbility
extends TriggeredAbilityImpl {
    CurseOfHospitalityTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CurseOfHospitalityEffect());
    }

    private CurseOfHospitalityTriggeredAbility(CurseOfHospitalityTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CurseOfHospitalityTriggeredAbility copy() {
        return new CurseOfHospitalityTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedEvent dEvent = (DamagedEvent)event;
        Permanent permanent = this.getSourcePermanentIfItStillExists(game);
        if (!dEvent.isCombatDamage() || permanent == null || !dEvent.getPlayerId().equals(permanent.getAttachedTo())) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(game.getControllerId(dEvent.getSourceId())));
        return true;
    }

    public String getRule() {
        return "Whenever a creature deals combat damage to enchanted player, that player exiles the top card of their library. Until end of turn, that creature's controller may play that card and they may spend mana as though it were mana of any color to cast that spell.";
    }
}

