/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class CurseOfInertiaTapOrUntapTargetEffect
extends OneShotEffect {
    public CurseOfInertiaTapOrUntapTargetEffect() {
        super(Outcome.Tap);
        this.staticText = "tap or untap target permanent of their choice";
    }

    private CurseOfInertiaTapOrUntapTargetEffect(CurseOfInertiaTapOrUntapTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetPermanent;
        Player player = game.getPlayer(((Target)source.getTargets().get(0)).getTargetController());
        if (player != null && (targetPermanent = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null) {
            if (targetPermanent.isTapped()) {
                if (player.chooseUse(Outcome.Untap, "Untap that permanent?", source, game)) {
                    targetPermanent.untap(game);
                }
            } else if (player.chooseUse(Outcome.Tap, "Tap that permanent?", source, game)) {
                targetPermanent.tap(source, game);
            }
            return true;
        }
        return false;
    }

    public CurseOfInertiaTapOrUntapTargetEffect copy() {
        return new CurseOfInertiaTapOrUntapTargetEffect(this);
    }
}

