/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPlayer;

class CurseOfLeechesEffect
extends ReplacementEffectImpl {
    CurseOfLeechesEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "as this permanent transforms into {this}, attach it to a player";
    }

    private CurseOfLeechesEffect(CurseOfLeechesEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetPlayer target = new TargetPlayer();
        target.withChooseHint("Player to attach to").withNotTarget(true);
        controller.choose(Outcome.Detriment, (Target)target, source, game);
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        permanent.addAttachment(target.getFirstTarget(), source, game);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TRANSFORMING;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.getSourceId().equals(event.getTargetId());
    }

    public CurseOfLeechesEffect copy() {
        return new CurseOfLeechesEffect(this);
    }
}

