/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CurseOfMisfortunesEffect
extends OneShotEffect {
    CurseOfMisfortunesEffect() {
        super(Outcome.Detriment);
        this.staticText = "you may search your library for a Curse card that doesn't have the same name as a Curse attached to enchanted player, put it onto the battlefield attached to that player, then shuffle";
    }

    private CurseOfMisfortunesEffect(CurseOfMisfortunesEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (controller != null && enchantment != null && enchantment.getAttachedTo() != null) {
            Player targetPlayer = game.getPlayer(enchantment.getAttachedTo());
            Player player = game.getPlayer(source.getControllerId());
            if (player != null && targetPlayer != null) {
                Card card;
                FilterCard filter = new FilterCard("Curse card that doesn't have the same name as a Curse attached to enchanted player");
                filter.add((Predicate)SubType.CURSE.getPredicate());
                for (UUID attachmentId : targetPlayer.getAttachments()) {
                    Permanent attachment = game.getPermanent(attachmentId);
                    if (attachment == null || !attachment.hasSubtype(SubType.CURSE, game)) continue;
                    filter.add(Predicates.not((Predicate)new NamePredicate(attachment.getName())));
                }
                TargetCardInLibrary targetCard = new TargetCardInLibrary(filter);
                if (player.searchLibrary(targetCard, source, game) && (card = game.getCard(targetCard.getFirstTarget())) != null) {
                    this.setTargetPointer((TargetPointer)new FixedTarget(targetPlayer.getId()));
                    game.getState().setValue("attachTo:" + card.getId(), (Object)targetPlayer.getId());
                    if (controller.moveCards(card, Zone.BATTLEFIELD, source, game)) {
                        targetPlayer.addAttachment(card.getId(), source, game);
                    }
                }
                player.shuffleLibrary(source, game);
            }
            return true;
        }
        return false;
    }

    public CurseOfMisfortunesEffect copy() {
        return new CurseOfMisfortunesEffect(this);
    }
}

