/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CurseOfPredationTriggeredAbility
extends TriggeredAbilityImpl {
    public CurseOfPredationTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance(), Outcome.BoostCreature), false);
    }

    public CurseOfPredationTriggeredAbility(Effect effect, boolean optional, String text) {
        super(Zone.BATTLEFIELD, effect, optional);
    }

    private CurseOfPredationTriggeredAbility(CurseOfPredationTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment;
        Player defender = game.getPlayer(event.getTargetId());
        if (defender != null && (enchantment = game.getPermanent(this.getSourceId())) != null && enchantment.isAttachedTo(defender.getId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature attacks enchanted player, put a +1/+1 counter on it.";
    }

    public CurseOfPredationTriggeredAbility copy() {
        return new CurseOfPredationTriggeredAbility(this);
    }
}

