/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.c.CurseOfShakenFaithEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.watchers.common.SpellsCastWatcher;

class CurseOfShakenFaithTriggeredAbility
extends TriggeredAbilityImpl {
    public CurseOfShakenFaithTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CurseOfShakenFaithEffect());
        this.setTriggerPhrase("Whenever enchanted player casts a spell other than the first spell they cast each turn or copies a spell, ");
    }

    private CurseOfShakenFaithTriggeredAbility(CurseOfShakenFaithTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CurseOfShakenFaithTriggeredAbility copy() {
        return new CurseOfShakenFaithTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COPIED_STACKOBJECT || event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment = game.getPermanentOrLKIBattlefield(this.sourceId);
        if (enchantment != null) {
            UUID enchantedPlayerId = enchantment.getAttachedTo();
            Spell spell = game.getSpell(event.getTargetId());
            if (spell != null && spell.isControlledBy(enchantedPlayerId)) {
                if (event.getType() == GameEvent.EventType.COPIED_STACKOBJECT) {
                    return true;
                }
                SpellsCastWatcher watcher = (SpellsCastWatcher)game.getState().getWatcher(SpellsCastWatcher.class);
                if (watcher != null) {
                    return watcher.getSpellsCastThisTurn(enchantedPlayerId).size() > 1;
                }
            }
        }
        return false;
    }
}

