/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class CurseOfSilenceCostEffect
extends CostModificationEffectImpl {
    CurseOfSilenceCostEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment, CostModificationType.INCREASE_COST);
        this.staticText = "Spells with the chosen name enchanted player casts cost {2} more to cast";
    }

    private CurseOfSilenceCostEffect(CurseOfSilenceCostEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public CurseOfSilenceCostEffect copy() {
        return new CurseOfSilenceCostEffect(this);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.increaseCost((Ability)abilityToModify, (int)2);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Permanent enchantment;
        if (abilityToModify instanceof SpellAbility && (enchantment = source.getSourcePermanentIfItStillExists(game)) != null && abilityToModify.isControlledBy(enchantment.getAttachedTo())) {
            Card card = game.getCard(abilityToModify.getSourceId());
            String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
            if (card != null && cardName != null && !cardName.isEmpty()) {
                return CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game);
            }
        }
        return false;
    }
}

