/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class CurseOfSilenceTriggeredAbility
extends TriggeredAbilityImpl {
    public CurseOfSilenceTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DoIfCostPaid((Effect)new DrawCardSourceControllerEffect(1), (Cost)new SacrificeSourceCost()));
        this.setTriggerPhrase("Whenever enchanted player casts a spell with the chosen name, ");
    }

    private CurseOfSilenceTriggeredAbility(CurseOfSilenceTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CurseOfSilenceTriggeredAbility copy() {
        return new CurseOfSilenceTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment = this.getSourcePermanentIfItStillExists(game);
        if (enchantment != null && event.getPlayerId().equals(enchantment.getAttachedTo())) {
            Card card = game.getCard(event.getSourceId());
            String cardName = (String)game.getState().getValue(this.sourceId.toString() + "NAMED_CARD");
            if (card != null && cardName != null && !cardName.isEmpty()) {
                return CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game);
            }
        }
        return false;
    }
}

