/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CurseOfTheForsakenTriggeredAbility
extends TriggeredAbilityImpl {
    public CurseOfTheForsakenTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainLifeTargetEffect(1), false);
    }

    public CurseOfTheForsakenTriggeredAbility(Effect effect, boolean optional, String text) {
        super(Zone.BATTLEFIELD, effect, optional);
    }

    private CurseOfTheForsakenTriggeredAbility(CurseOfTheForsakenTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment;
        Player defender = game.getPlayer(event.getTargetId());
        if (defender != null && (enchantment = game.getPermanent(this.getSourceId())) != null && enchantment.isAttachedTo(defender.getId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature attacks enchanted player, its controller gains 1 life.";
    }

    public CurseOfTheForsakenTriggeredAbility copy() {
        return new CurseOfTheForsakenTriggeredAbility(this);
    }
}

