/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CurseOfTheNightlyHuntEffect
extends RequirementEffect {
    CurseOfTheNightlyHuntEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "Creatures enchanted player controls attack each combat if able";
    }

    private CurseOfTheNightlyHuntEffect(CurseOfTheNightlyHuntEffect effect) {
        super((RequirementEffect)effect);
    }

    public CurseOfTheNightlyHuntEffect copy() {
        return new CurseOfTheNightlyHuntEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        return enchantment != null && enchantment.getAttachedTo() != null && permanent.isControlledBy(enchantment.getAttachedTo());
    }

    public boolean mustAttack(Game game) {
        return true;
    }

    public boolean mustBlock(Game game) {
        return false;
    }
}

