/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CurseOfUnbindingEffect
extends OneShotEffect {
    CurseOfUnbindingEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player reveals cards from the top of their library until they reveal a creature card. Put that card onto the battlefield under your control. That player puts the rest of the revealed cards into their graveyard";
    }

    private CurseOfUnbindingEffect(CurseOfUnbindingEffect effect) {
        super((OneShotEffect)effect);
    }

    public CurseOfUnbindingEffect copy() {
        return new CurseOfUnbindingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        Card toHand = null;
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (!card.isCreature(game)) continue;
            toHand = card;
            break;
        }
        player.revealCards(source, (Cards)cards, game);
        Player controller = game.getPlayer(source.getControllerId());
        if (toHand != null && controller != null) {
            controller.moveCards(toHand, Zone.BATTLEFIELD, source, game);
        }
        cards.retainZone(Zone.LIBRARY, game);
        player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        return true;
    }
}

