/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CurseOfVengeanceTriggeredAbility
extends TriggeredAbilityImpl {
    CurseOfVengeanceTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersTargetEffect(CounterType.SPITE.createInstance(), Outcome.Detriment), false);
    }

    private CurseOfVengeanceTriggeredAbility(CurseOfVengeanceTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment = game.getPermanent(this.getSourceId());
        Spell spell = game.getStack().getSpell(event.getSourceId());
        if (enchantment != null && spell != null && enchantment.isAttachedTo(spell.getControllerId())) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(this.getSourceId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever enchanted player casts a spell, put a spite counter on {this}.";
    }

    public CurseOfVengeanceTriggeredAbility copy() {
        return new CurseOfVengeanceTriggeredAbility(this);
    }
}

