/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class AddCounterAbility
extends TriggeredAbilityImpl {
    public AddCounterAbility() {
        super(Zone.BATTLEFIELD, (Effect)new AddCountersSourceEffect(CounterType.CHARGE.createInstance(1)), false);
    }

    private AddCounterAbility(AddCounterAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public AddCounterAbility copy() {
        return new AddCounterAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)this.getSourceId(), (Game)game);
        return subType != null && (spell = game.getStack().getSpell(event.getTargetId())) != null && spell.isControlledBy(this.getControllerId()) && spell.hasSubtype(subType, game);
    }

    public String getRule() {
        return "Whenever you cast a spell of the chosen type, put a charge counter on {this}.";
    }
}

