/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.cards.d.DampingEngine;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DampingEngineEffect
extends ContinuousRuleModifyingEffectImpl {
    DampingEngineEffect() {
        super(Duration.WhileOnBattlefield, Outcome.AIDontUseIt);
        this.staticText = "A player who controls more permanents than each other player can't play lands or cast artifact, creature, or enchantment spells.";
    }

    private DampingEngineEffect(DampingEngineEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public DampingEngineEffect copy() {
        return new DampingEngineEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = source.getSourceObject(game);
        if (mageObject != null) {
            return "You can't play the land or cast the spell (" + mageObject.getName() + " in play).";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.PLAY_LAND || event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        Permanent dampingEngine = source.getSourcePermanentIfItStillExists(game);
        Card card = game.getCard(event.getSourceId());
        if (player == null || dampingEngine == null || card == null) {
            return false;
        }
        if (!(card.isCreature(game) || card.isArtifact(game) || card.isEnchantment(game) || card.isLand(game))) {
            return false;
        }
        return DampingEngine.checkPlayer(player, game) && !DampingEngine.checkValue(player.getId(), source, game);
    }
}

