/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.keyword.EquipAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class DanLewisEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterControlledArtifactPermanent();

    public DanLewisEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "noncreature, non-Equipment artifacts you control are Equipment in addition to their other types and have \"Equipped creature gets +1/+0\" and equip {1}";
    }

    private DanLewisEffect(DanLewisEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        if (layer == Layer.TypeChangingEffects_4) {
            this.affectedObjectList.clear();
            for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
                this.affectedObjectList.add(new MageObjectReference((MageObject)permanent, game));
            }
        }
        for (MageObjectReference mor : this.affectedObjectList) {
            Permanent permanent = mor.getPermanent(game);
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.addSubType(game, new SubType[]{SubType.EQUIPMENT});
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    permanent.addAbility((Ability)new SimpleStaticAbility((Effect)new BoostEquippedEffect(1, 0)), source.getSourceId(), game);
                    permanent.addAbility((Ability)new EquipAbility(1, false), source.getSourceId(), game);
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public DanLewisEffect copy() {
        return new DanLewisEffect(this);
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case AbilityAddingRemovingEffects_6: {
                return true;
            }
        }
        return false;
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
        filter.add(Predicates.not((Predicate)SubType.EQUIPMENT.getPredicate()));
    }
}

