/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Collection;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.CardIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;
import mage.target.common.TargetSacrifice;

class DanseMacabreEffect
extends OneShotEffect {
    DanseMacabreEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player sacrifices a nontoken creature. Roll a d20 and add the toughness of the creature you sacrificed this way.<br>1-14 | Return a creature card put into a graveyard this way to the battlefield under your control.<br>15+ | Return up to two creature cards put into graveyards this way to the battlefield under your control";
    }

    private DanseMacabreEffect(DanseMacabreEffect effect) {
        super((OneShotEffect)effect);
    }

    public DanseMacabreEffect copy() {
        return new DanseMacabreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        TargetCardInGraveyard target;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int toughness = 0;
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE_NON_TOKEN, playerId, source, game) < 1) continue;
            TargetSacrifice target2 = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE_NON_TOKEN);
            player.choose(Outcome.Sacrifice, (Target)target2, source, game);
            Permanent permanent = game.getPermanent(target2.getFirstTarget());
            if (permanent == null) continue;
            if (source.isControlledBy(playerId)) {
                toughness += permanent.getToughness().getValue();
            }
            cards.add((Card)permanent);
            permanent.sacrifice(source, game);
        }
        int result = controller.rollDice(this.outcome, source, game, 20) + toughness;
        cards.retainZone(Zone.GRAVEYARD, game);
        if (cards.isEmpty()) {
            return true;
        }
        FilterCreatureCard filterCard = new FilterCreatureCard("creature card put into a graveyard this way");
        filterCard.add(Predicates.or((Iterable)cards.stream().map(CardIdPredicate::new).collect(Collectors.toSet())));
        if (result >= 15) {
            target = new TargetCardInGraveyard(0, 2, (FilterCard)filterCard);
        } else if (result > 0) {
            target = new TargetCardInGraveyard((FilterCard)filterCard);
        } else {
            return true;
        }
        target.withNotTarget(true);
        controller.choose(Outcome.PutCreatureInPlay, (Target)target, source, game);
        controller.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.BATTLEFIELD, source, game);
        return true;
    }
}

