/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeXTargetCost;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.d.DargoTheShipwreckerWatcher;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class DargoTheShipwreckerEffect
extends CostModificationEffectImpl {
    DargoTheShipwreckerEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit, CostModificationType.REDUCE_COST);
    }

    private DargoTheShipwreckerEffect(DargoTheShipwreckerEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        DargoTheShipwreckerWatcher watcher;
        SpellAbility spellAbility = (SpellAbility)abilityToModify;
        int reduction = 0;
        for (Cost cost : spellAbility.getCosts()) {
            if (!(cost instanceof SacrificeXTargetCost)) continue;
            if (game.inCheckPlayableState()) {
                reduction += ((SacrificeXTargetCost)cost).getMaxValue((Ability)spellAbility, game);
                break;
            }
            reduction += ((SacrificeXTargetCost)cost).getAmount();
            break;
        }
        if ((watcher = (DargoTheShipwreckerWatcher)game.getState().getWatcher(DargoTheShipwreckerWatcher.class)) != null) {
            reduction += watcher.getSacCount(source.getControllerId());
        }
        CardUtil.adjustCost((SpellAbility)spellAbility, (int)(reduction * 2));
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify instanceof SpellAbility && abilityToModify.getSourceId().equals(source.getSourceId());
    }

    public DargoTheShipwreckerEffect copy() {
        return new DargoTheShipwreckerEffect(this);
    }
}

