/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.cards.d.DarksteelMonolithAlternativeCost;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class DarksteelMonolithAddAltCostEffect
extends ContinuousEffectImpl {
    DarksteelMonolithAddAltCostEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Once each turn, you may pay {0} rather than pay the mana cost for a colorless spell you cast from your hand.";
    }

    private DarksteelMonolithAddAltCostEffect(DarksteelMonolithAddAltCostEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public DarksteelMonolithAddAltCostEffect copy() {
        return new DarksteelMonolithAddAltCostEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent sourcePermanent;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (sourcePermanent = game.getPermanent(source.getSourceId())) != null) {
            Boolean wasItUsed = (Boolean)game.getState().getValue(sourcePermanent.getId().toString() + sourcePermanent.getZoneChangeCounter(game) + sourcePermanent.getTurnsOnBattlefield());
            if (wasItUsed == null) {
                DarksteelMonolithAlternativeCost alternateCostAbility = new DarksteelMonolithAlternativeCost();
                alternateCostAbility.setSourceId(source.getSourceId());
                controller.getAlternativeSourceCosts().add(alternateCostAbility);
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

