/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.condition.common.KickedCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class DauntlessUnityEffect
extends OneShotEffect {
    DauntlessUnityEffect() {
        super(Outcome.Benefit);
        this.staticText = "Creatures you control get +1/+1 until end of turn. If this spell was kicked, those creatures get +2/+1 until end of turn instead.";
    }

    private DauntlessUnityEffect(DauntlessUnityEffect effect) {
        super((OneShotEffect)effect);
    }

    public DauntlessUnityEffect copy() {
        return new DauntlessUnityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (KickedCondition.ONCE.apply(game, source)) {
            game.addEffect((ContinuousEffect)new BoostControlledEffect(2, 1, Duration.EndOfTurn), source);
        } else {
            game.addEffect((ContinuousEffect)new BoostControlledEffect(1, 1, Duration.EndOfTurn), source);
        }
        return true;
    }
}

