/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.players.Player;
import mage.util.CardUtil;

class DauthiVoidwalkerReplacementEffect
extends ReplacementEffectImpl {
    DauthiVoidwalkerReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "if a card would be put into an opponent's graveyard from anywhere, instead exile it with a void counter on it";
    }

    private DauthiVoidwalkerReplacementEffect(DauthiVoidwalkerReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public DauthiVoidwalkerReplacementEffect copy() {
        return new DauthiVoidwalkerReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent card = ((ZoneChangeEvent)event).getTarget();
        if (card == null) {
            card = game.getCard(event.getTargetId());
        }
        if (controller == null || card == null) {
            return false;
        }
        CardUtil.moveCardWithCounter((Game)game, (Ability)source, (Player)controller, (Card)card, (Zone)Zone.EXILED, (Counter)CounterType.VOID.createInstance());
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return ((ZoneChangeEvent)event).getToZone() == Zone.GRAVEYARD && !(((ZoneChangeEvent)event).getTarget() instanceof PermanentToken) && game.getOpponents(source.getControllerId()).contains(game.getOwnerId(event.getTargetId()));
    }
}

