/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.d.DavrosDalekCreatorFirstChoice;
import mage.cards.d.DavrosDalekCreatorSecondChoice;
import mage.choices.FaceVillainousChoice;
import mage.choices.VillainousChoice;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.watchers.common.PlayerLostLifeWatcher;

class DavrosDalekCreatorEffect
extends OneShotEffect {
    private static final FaceVillainousChoice choice = new FaceVillainousChoice(Outcome.Detriment, (VillainousChoice)new DavrosDalekCreatorFirstChoice(), (VillainousChoice)new DavrosDalekCreatorSecondChoice());

    DavrosDalekCreatorEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then each opponent who lost 3 or more life this turn " + choice.generateRule();
    }

    private DavrosDalekCreatorEffect(DavrosDalekCreatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public DavrosDalekCreatorEffect copy() {
        return new DavrosDalekCreatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        PlayerLostLifeWatcher watcher = (PlayerLostLifeWatcher)game.getState().getWatcher(PlayerLostLifeWatcher.class);
        Set opponents = game.getOpponents(source.getControllerId());
        if (watcher != null) {
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player;
                int lostLive;
                if (!opponents.contains(playerId) || (lostLive = watcher.getLifeLost(playerId)) < 3 || (player = game.getPlayer(playerId)) == null) continue;
                choice.faceChoice(player, game, source);
            }
        }
        return true;
    }
}

