/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.players.Player;

class DawnEffect
extends OneShotEffect {
    private static final FilterCard filter2orLess = new FilterCreatureCard("creatures with power less than or equal to 2");

    DawnEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return all creature cards with power 2 or less from your graveyard to your hand.";
    }

    private DawnEffect(DawnEffect effect) {
        super((OneShotEffect)effect);
    }

    public DawnEffect copy() {
        return new DawnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            Set cards = player.getGraveyard().getCards(filter2orLess, game);
            player.moveCards(cards, Zone.HAND, source, game);
            return true;
        }
        return false;
    }

    static {
        filter2orLess.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, 3));
    }
}

