/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class DaxosBlessedByTheSunAbility
extends TriggeredAbilityImpl {
    DaxosBlessedByTheSunAbility() {
        super(Zone.BATTLEFIELD, (Effect)new GainLifeEffect(1));
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private DaxosBlessedByTheSunAbility(DaxosBlessedByTheSunAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD || event.getType() == GameEvent.EventType.ZONE_CHANGE && ((ZoneChangeEvent)event).isDiesEvent();
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getTargetId().equals(this.getSourceId())) {
            return false;
        }
        Permanent creature = game.getPermanentOrLKIBattlefield(event.getTargetId());
        return creature != null && creature.isCreature(game) && creature.isControlledBy(this.getControllerId());
    }

    public String getRule() {
        return "Whenever another creature you control enters the battlefield or dies, you gain 1 life.";
    }

    public DaxosBlessedByTheSunAbility copy() {
        return new DaxosBlessedByTheSunAbility(this);
    }
}

