/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class DaxosOfMeletisEffect
extends OneShotEffect {
    DaxosOfMeletisEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "exile the top card of that player's library. You gain life equal to that card's mana value. Until end of turn, you may cast that card and you may spend mana as though it were mana of any color to cast that spell";
    }

    private DaxosOfMeletisEffect(DaxosOfMeletisEffect effect) {
        super((OneShotEffect)effect);
    }

    public DaxosOfMeletisEffect copy() {
        return new DaxosOfMeletisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player damagedPlayer;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (damagedPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source))) != null) {
            MageObject sourceObject = game.getObject(source);
            UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
            Card card = damagedPlayer.getLibrary().getFromTop(game);
            if (card != null && sourceObject != null) {
                controller.moveCardsToExile(card, source, game, true, exileId, sourceObject.getIdName());
                controller.gainLife(card.getManaValue(), game, source);
                if (card.getSpellAbility() != null) {
                    CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.EndOfTurn, (boolean)true);
                }
            }
            return true;
        }
        return false;
    }
}

