/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.d.DazzlingReflectionPreventEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class DazzlingReflectionEffect
extends OneShotEffect {
    DazzlingReflectionEffect() {
        super(Outcome.Benefit);
        this.staticText = "You gain life equal to target creature's power. The next time that creature would deal damage this turn, prevent that damage";
    }

    private DazzlingReflectionEffect(DazzlingReflectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public DazzlingReflectionEffect copy() {
        return new DazzlingReflectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (targetCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source)) != null) {
            controller.gainLife(targetCreature.getPower().getValue(), game, source);
            DazzlingReflectionPreventEffect effect = new DazzlingReflectionPreventEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetCreature, game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

