/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.d;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.EachTargetPointer;
import mage.target.targetpointer.TargetPointer;

class DeadReckoningEffect
extends OneShotEffect {
    DeadReckoningEffect() {
        super(Outcome.Damage);
        this.staticText = "you may put target creature card from your graveyard on top of your library. If you do, {this} deals damage equal to that card's power to target creature";
        this.setTargetPointer((TargetPointer)new EachTargetPointer());
    }

    private DeadReckoningEffect(DeadReckoningEffect effect) {
        super((OneShotEffect)effect);
    }

    public DeadReckoningEffect copy() {
        return new DeadReckoningEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        List targets = this.getTargetPointer().getTargets(game, source);
        Card card = game.getCard((UUID)targets.get(0));
        if (player == null || card == null || !player.chooseUse(this.outcome, "Put " + card.getName() + " on top of your library?", source, game)) {
            return false;
        }
        int power = card.getPower().getValue();
        player.putCardsOnTopOfLibrary(card, game, source, false);
        if (targets.size() < 2 || power < 1) {
            return true;
        }
        Permanent permanent = game.getPermanent((UUID)targets.get(1));
        if (permanent == null) {
            return true;
        }
        permanent.damage(power, source, game);
        return true;
    }
}

